function [n_quad_1d, n_quad_2d, quad_1d_point, quad_2d_point, quad_1d_weight, quad_2d_weight]=set_quad(degree)

global_vars;

if degree == 1
    n_quad_1d = 1;
    quad_1d_point = 1/2;
    quad_1d_weight = 1;
    n_quad_2d = 1;
    quad_2d_point = [1/3, 1/3];
    quad_2d_weight = 1/2;
elseif degree == 2
    n_quad_1d = 2;
    quad_1d_point = [(3-sqrt(3))/6;(3+sqrt(3))/6];
    quad_1d_weight = [1/2;1/2];
    n_quad_2d = 3;
    quad_2d_point = [1/6, 1/6; 4/6, 1/6; 1/6, 4/6];
    quad_2d_weight = [1/6; 1/6; 1/6];
elseif degree == 3
    n_quad_1d = 2;
    quad_1d_point = [(3-sqrt(3))/6;(3+sqrt(3))/6];
    quad_1d_weight = [1/2;1/2];
    n_quad_2d = 3;
    quad_2d_point = [1/6, 1/6; 4/6, 1/6; 1/6, 4/6];
    quad_2d_weight = [1/6; 1/6; 1/6];
elseif degree == 6
    a = 0.8738219710;
    b = 0.0630890144;
    c = 0.0630890144;
    d = 0.5014265096;
    e = 0.2492867451;
    f = 0.2492867451;
    g = 0.6365024991;
    h = 0.3103524510;
    i = 0.0531450498;
    W1 = 0.0508449063;
    W2 = 0.1167862757;
    W3 = 0.0828510756;
    n_quad_1d = 2;
    quad_1d_point = [(3-sqrt(3))/6;(3+sqrt(3))/6];
    quad_1d_weight = [1/2;1/2];
    n_quad_2d = 12;
    quad_2d_point = [a b;b a;b b;d e;e d;e e;g h;g i;h g;h i;i g;i h];
    quad_2d_weight = [W1;W1;W1;W2;W2;W2;W3;W3;W3;W3;W3;W3]/2;
elseif degree == 7
    quad_2d_point = [0.33333333333333 0.33333333333333;...
        0.45929258829272 0.45929258829272;...
        0.45929258829272 0.08141482341455;...
        0.08141482341455 0.45929258829272;...
        0.17056930775176 0.17056930775176;...
        0.17056930775176 0.65886138449648;...
        0.65886138449648 0.17056930775176;...
        0.05054722831703 0.05054722831703;...
        0.05054722831703 0.89890554336594;...
        0.89890554336594 0.05054722831703;...
        0.26311282963464 0.72849239295540;...
        0.72849239295540 0.00839477740996;...
        0.00839477740996 0.26311282963464;...
        0.72849239295540 0.26311282963464;...
        0.26311282963464 0.00839477740996;...
        0.00839477740996 0.72849239295540];
    
    quad_2d_weight = [0.14431560767779; 0.09509163426728; 0.09509163426728;...
        0.09509163426728; 0.10321737053472; 0.10321737053472; 0.10321737053472;...
        0.03245849762320; 0.03245849762320; 0.03245849762320; 0.02723031417443;...
        0.02723031417443; 0.02723031417443; 0.02723031417443; 0.02723031417443;...
        0.02723031417443];
    n_quad_2d = length(quad_2d_weight);    
    load Gauss_quadrature_1d.mat;
end